<?php
header("Access-Control-Allow-Headers: Authorization, Content-Type");
header("Access-Control-Allow-Origin: *");
header('content-type: application/json; charset=utf-8');

    require "email.php";

    $inputJSON = file_get_contents('php://input');
    $input = json_decode($inputJSON, TRUE);

    $name = $input['name'];
    $mail = $input['email'];
    $contact = $input['contact'];
    $message = $input['message'];

    $result['message'] = '';
    $result['error']  = false;

    if(empty($name)) {
      $result['message'] = 'Insira o seu nome.';
      $result['error']  = true;
    }
    if(empty($mail)){
      $result['message'] = 'Insira o seu email.';
      $result['error']  = true;
    }
    if(empty($message)){
      $result['message'] = 'Insira uma mensagem.';
      $result['error']  = true;
    };
    if(empty($contact)){
      $result['message'] = 'Insira o seu contacto.';
      $result['error']  = true;
    }
    if (!filter_var($mail, FILTER_VALIDATE_EMAIL)){
      $result['message'] = 'Email invalido.';
      $result['error']  = true;
    }

    if(!$result['error']) {

      $email = [
        'name' => $name,
        'email' => $mail,
        'contact' => $contact,
        'message' => $message

      ];


      $success = sendEmail($email);

        if( $success['error']) {
            $result['message'] =   $success['message'];
        }else{
            $result['message'] = 'Email enviado com sucesso';
            echo json_encode($result);
            return;
        }

    }


  echo json_encode($result);
